/*********** V1 changed names, add zeroset pgm *****/
/*********** V2 DRV8871 higher speed **********/
/*********** V3 code cleanup *********************************************/
/*   Changed names of switch states              */
/*   Rewrote state machine for switches          */
/*   Changed thresholds on v9 & v12              */
/*   Blocked switch processing if motors moving  */
/*   Changed run motors into state machine for shadesmoving */
/*   Made arrays of shadeDownPosition[], EEadr_shadeDownPosition[], down[], EEadr_pos[] & pos[] */
/*   Added routines Jog1(dir), Jog2(dir)....Jog6(dir) */
/*   Added button sel of speed and accel for development testing   */
/*   Added sunrise calc. Added DownTimeLimits based on UpTimeOffset */
/*   Added maxDays in month for all months except leapyear */
/*   Added HB LED */
/*   Recal c9 & c12 */
/*   Ver 3.0 initial release June 4, 2019 */
/*   This version uses (90%) program memory and 65% of global variables */

/********** V3.10 ************/
/*   Eliminate SET_STEPS_PER_SEC2 & CLEAR_BAT_MSG from EE   */
/*   Made stepsPerSec2 = stepsPerSec  */
/*   Changed range of stepsPerSec from 100,700,100 to 300,400,25 for "tuning" */
/*   Disable read buttons unless shadecmd OFF to fix speed control */
/*   Remove include utility/Adafruit_MS_PWMServodriver.h */

/********** V3.11 ***************/
/*   Eliminated define ON 1 not used  */
/*   Added rtc.begin() to startup  */

/********** V3.13 **************/
/*   Moved CalcSunTime() so correct at startup */
/*   Added Flash 12V message every period1 */
/*   Added flash 9V replace bat message every period2 */
/*   Removed read/write EE of batteryState */
/*   Removed rqt for pwrMode & batteryState from midnight calc & minute display update */
/*   Fixed stepsPerSec = 400 & removed setting from buttons */
/*   Removed stepsPerSec & batteryState from EE */

/*************** V3.14 ******************/
/*   Changed manual cmd from 3 button sequence to MAN (left) button single push */

/**************** V3.15 **********/
/*   Added debug code for EE, State & Voltage serial outout */
/*   Added big jog up serial commands */
/*   Fixed overflow problem with if(pos[0] + pos[1] ...>0) */
/*   This is debug code do not ship */

/************** V3.16 **************/
/*  Fixed overflow problem with if(pos[0] + pos[1] ... > 0) */

/****************V3.17**************/
/*  Changed maximum upTimeOffset from 5 to 8 hrs  */
/*  CHanged minimum downTimeOffset from -5 to -8 hrs */
/*  Changed minDownTimeOffset wrt sunset from -5 to -8 hrs */
/*  Changed maximum shadeDownPosition[] from 6 to 8 ft */

/**************V3.18************/
/* Increase masicmum shadeDownPosition() from 8 to 9 ft */

/**************V3.19***********************/
/*  Fixed EE save UTC offset; previously not saved */
/*  Fixed motor position read from EE; previously not initialized after reset */
/*  Dont flash low bat msg when shades moving */

/***********  V3.20 ********/
/* Added manualOption setting to shades; stored in EE */

/*********** 3.21 *******/
/**  Fixed LCD spelling "Manual Command"  **/
/**  Changed LCD display in SetTargetPositions to show which shade or all shades lowering or raising **/
/**  Fixed SetTargetPosition logic so timer commands work cirrectly with Individual manual commands  **/

/*********** 3.22 *******/
/** Increase masicmum shadeDownPosition() from 9 to 12 ft **/

/*********** 3.23 *******/
/** Shades will not automatically lower or raise if 9V battery is bad **/
/** Changed 9V and 12V warning times so more noticable **/

/*********** 3.24  ******/
/** Changed timer up logic so shades rise (but do not lower) even when uptime = downtime  **/
/** Added ADJUSTABLE manual mode. **/
/** Added display of manual mode during reset **/
/** Added float variable pres for shade position resolution **/
/** Added new state PROGRAM_OPTIONS containing SET_MANUAL_OPTION & SET_PRES **/
/** Added new state SET_PRES. Also added to EEPROM **/
/** NOTE need to now use version 1.12 of myEEinitialize to set these defaults in EE  **/

/************* 3.25 *****************/
/** Added save Y/N option to setFloatVariable so Manual ADJ mode changes are temporary **/
/** Revised LCD messages for manual mode shade movement  **/
/** Changed min value for upime offset -8 (was -1) **/


// include the library code:
#include <Wire.h>
#include <AccelStepper.h>
#include <Adafruit_MotorShield.h>

#include <Adafruit_RGBLCDShield.h>
#include <utility/Adafruit_MCP23017.h>
#include "RTClib.h"
#include <TimeLord.h>
#include <EEPROM.h>


RTC_PCF8523 rtc;
#define MAX_MOTORS 6
#define LED 13 //SCK 

Adafruit_RGBLCDShield lcd = Adafruit_RGBLCDShield();

Adafruit_MotorShield AFMStop(0x7C); // top shield, no jumpers 
Adafruit_MotorShield AFMSmid(0x7D); // middle shield rightmost jumper closed
Adafruit_MotorShield AFMSbot(0x7E); // bottom shield 2nd from right jumper closed 

Adafruit_StepperMotor *myStepper1 = AFMStop.getStepper(200, 1); // 200 step/rev motor on top shield left side
Adafruit_StepperMotor *myStepper2 = AFMStop.getStepper(200, 2); // 200 step/rev motor on top shield right side
Adafruit_StepperMotor *myStepper3 = AFMSmid.getStepper(200, 1); // 200 step/rev motor on mid shield left side
Adafruit_StepperMotor *myStepper4 = AFMSmid.getStepper(200, 2); // 200 step/rev motor on mid shield right side
Adafruit_StepperMotor *myStepper5 = AFMSbot.getStepper(200, 1); // 200 step/rev motor on bot shield left side
Adafruit_StepperMotor *myStepper6 = AFMSbot.getStepper(200, 2); // 200 step/rev motor on bot shield right side


void forwardstep1() {myStepper1->onestep(FORWARD, DOUBLE);}
void backwardstep1() {myStepper1->onestep(BACKWARD, DOUBLE);}
AccelStepper stepper1(forwardstep1, backwardstep1);

void forwardstep2() {myStepper2->onestep(FORWARD, DOUBLE);}
void backwardstep2() {myStepper2->onestep(BACKWARD, DOUBLE);}
AccelStepper stepper2(forwardstep2, backwardstep2);

void forwardstep3() {myStepper3->onestep(FORWARD, DOUBLE);}
void backwardstep3() {myStepper3->onestep(BACKWARD, DOUBLE);}
AccelStepper stepper3(forwardstep3, backwardstep3);

void forwardstep4() {myStepper4->onestep(FORWARD, DOUBLE);}
void backwardstep4() {myStepper4->onestep(BACKWARD, DOUBLE);}
AccelStepper stepper4(forwardstep4, backwardstep4);

void forwardstep5() {myStepper5->onestep(FORWARD, DOUBLE);}
void backwardstep5() {myStepper5->onestep(BACKWARD, DOUBLE);}
AccelStepper stepper5(forwardstep5, backwardstep5);

void forwardstep6() {myStepper6->onestep(FORWARD, DOUBLE);}
void backwardstep6() {myStepper6->onestep(BACKWARD, DOUBLE);}
AccelStepper stepper6(forwardstep6, backwardstep6);

/******* Colors for the LCD backlight color ******************/
#define BLACK 0x0 // Use to save power
#define RED 0x1
#define YELLOW 0x3
#define GREEN 0x2
#define TEAL 0x6
#define BLUE 0x4
#define VIOLET 0x5
#define WHITE 0x7

/********* States for main state machine ****************/
#define RUN 1
#define SET_YEAR 2
#define SET_MONTH 3
#define SET_DAY 4
#define SET_HOUR 5
#define SET_MINUTE 6
#define SET_UTC_OFFSET 7
#define SET_DST 8
#define SET_LONGITUDE 9
#define SET_LATITUDE 10
#define SET_UPTIMEOFFSET 11
#define SET_DNTIMEOFFSET 12
#define SET_SHADE1_DOWN 13
#define SET_SHADE2_DOWN 14
#define SET_SHADE3_DOWN 15
#define SET_SHADE4_DOWN 16
#define SET_SHADE5_DOWN 17
#define SET_SHADE6_DOWN 18
#define SET_SHADE1_UP 19
#define SET_SHADE2_UP 20
#define SET_SHADE3_UP 21
#define SET_SHADE4_UP 22
#define SET_SHADE5_UP 23
#define SET_SHADE6_UP 24
#define PROGRAM_TIME 25
#define PROGRAM_LOCATION 26
#define PROGRAM_SHADES 27
#define PROGRAM_ZEROSET 28
#define MANUAL_IND 29
#define SET_MANUAL_OPTION 30
#define MANUAL_ADJ 31
#define PROGRAM_OPTIONS 32
#define SET_POS_RES 33

/*********** States for dst **********/
#define US 0
#define MEX 1
#define NONE 2

/********** States for shadecmd & mancmd  *****/
#define OFF 0
#define DOWN 1
#define UP 2
#define UPORDOWN 3


/*********** States for shadesmoving ***********/
#define NOTMOVING 0
#define MOTOR1 1
#define MOTOR2 2
#define MOTOR3 3
#define MOTOR4 4
#define MOTOR5 5
#define MOTOR6 6

/*********** States for power monitoring ******/
#define PRIMARY 0
#define BACKUP 1
#define NG 0
#define OK 1
#define ON 1

/************* States for manualOption **/
#define ALL 0
#define INDIVIDUAL 1
#define ADJUSTABLE 2
#define NO 0
#define YES 1

#define JOG 89 // steps for 1/2 inch

int8_t buttons;

int    hb = 0; 
int    pwrMode = PRIMARY;
int    currentYear; 
int    currentMonth;
int    currentDay;
int    currentHour;
int    currentMin;
int    currentDow;
int    currentSec;
int    previousDay = 33; // forces sunset calc on startup
int    previousMin = 61; // forces default display on startup
int    priorDay = 33; // forces dst calc on startup
int    period1;
int    period2;
int    sunsethour;
int    sunsetmin;
int    sunrisehour;
int    sunrisemin;
int    dstoffset;
int    olddstoffset;
int    save = YES;  //save setting to EE

DateTime now;
unsigned long currentMillis;
unsigned long previousMillis;
unsigned long lastbuttonMillis;

float ver = 3.25;

int   down[MAX_MOTORS];
int   shadecmd = OFF;
int   shadesmoving = NOTMOVING;
int   shadeno;
float uptime;
float downtime;
float currentTimeInMin;
float previousTimeInMin;
int   v12Pin = A0;
int   v9Pin = A1;
int   c12;
int   c9;
int   state = RUN; 
int   maxDays = 31;
float  minDownTimeOffset; 
float  maxDownTimeOffset; 
int    batteryState = OK;
int    stepsPerSec = 400; 
int    stepsPerSec2 = 400; 
int    incomingByte = 0; 
int    needToRaise;

/********** These variables are stored in EE and recovered during startup. *******************/
int    utcOffset;
int    dst;
int    longitude;
int    latitude;
float  upTimeOffset;
float  downTimeOffset;
float  shadeDownPosition[MAX_MOTORS];
int    pos[MAX_MOTORS];
int    manualOption;
float  pres;

/*********** These are the starting addresses for the variables stored in EE. All are 2 bytes long. ****************/
const int EEadr_utcOffset = 0;
const int EEadr_dst = 2;
const int EEadr_longitude = 4; 
const int EEadr_latitude = 6;
const int EEadr_upTimeOffset = 8;
const int EEadr_downTimeOffset = 10;
const int EEadr_shadeDownPosition[MAX_MOTORS] = {12,14,16,18,20,22};
const int EEadr_pos[MAX_MOTORS] = {24,26,28,30,32,34};
const int EEadr_manualOption = 36;
const int EEadr_pres = 38;

/**************** Manually added prototypes because of &'s to make call by reference not call by value. *****************/
void setIntegerVariable(int8_t buttons,int &myVariable,int EEadr_Variable,int minValue,int maxValue,int incrValue);
void setFloatVariable(int8_t buttons,float &myVariable,int EEadr_Variable, float minValue,float maxValue,float incrValue,int save);
void setIntTextVariable(int8_t buttons,int &myVariable,int EEadr_Variable,int minValue,int maxValue,int incrValue);  
void setTimeVariable(int8_t buttons,int &myVariable,int minValue,int maxValue,int incrValue);

void setup() 
{
  
/************ Setup LCD and display version *****************/

  lcd.begin(16, 2); // set up LCD number of columns and rows 
  lcd.clear();
  lcd.setCursor(0,0); 
  lcd.setBacklight(YELLOW);
  lcd.print("AUTOSHADE");
  lcd.setCursor(0,1);
  lcd.print("Version ");
  lcd.print(ver);
  delay(3000);
 

/********* Start the motor driver  ***************/
  AFMStop.begin(); // Start the top shield 
  AFMSmid.begin(); // Start the mid shield 
  AFMSbot.begin(); // Start the bot shield 
  Wire.setClock(400000L); // 400000L sets I2C clock for 400KHz to provide 797 steps/s vs 265 at default 100KHz.  
   
  rtc.begin();

  pinMode(LED, OUTPUT); 

    
  //Serial.begin (9600);   
  //Serial.println(F("Enter 'D' for data"));

  
/*********** Read the variables stored in EE & initialize motor parameters ********************************/
  
  readEEdata();
  
  setStepperSpeedAccel(); // Includes postions read from EE after reset or power restore
  
  if(pos[0]||pos[1]||pos[2]||pos[3]||pos[4]||pos[5])  needToRaise = 1; // at least one shade is not UP

  lcd.clear();
  lcd.setCursor(0,0); 
  lcd.print(F("Manual mode is"));
  lcd.setCursor(0,1);
  LCDopt(manualOption);
  delay(3000);
   
} // end void setup()

void readEEdata(void)
{
  utcOffset = GetEEint(EEadr_utcOffset);
  dst       = GetEEint(EEadr_dst);
  longitude = GetEEint(EEadr_longitude);
  latitude  = GetEEint(EEadr_latitude);
  upTimeOffset       = (float) GetEEint(EEadr_upTimeOffset)/4;
  downTimeOffset     = (float) GetEEint(EEadr_downTimeOffset)/4;
  DownTimeLimits();
  for(int i=0; i<MAX_MOTORS; i++)
  {
    shadeDownPosition[i] = (float) GetEEint(EEadr_shadeDownPosition[i])/4;
  }
  for (int i=0; i<MAX_MOTORS; i++)
  {
    pos[i] = GetEEint(EEadr_pos[i]);
  }
  manualOption = GetEEint(EEadr_manualOption);
  pres = (float) GetEEint(EEadr_pres)/4;
}



void setStepperSpeedAccel(void)
{
  stepper1.setCurrentPosition(pos[0]);
  stepper1.setMaxSpeed(stepsPerSec);
  stepper1.setAcceleration(stepsPerSec2);   
  stepper2.setCurrentPosition(pos[1]);  
  stepper2.setMaxSpeed(stepsPerSec);
  stepper2.setAcceleration(stepsPerSec2);
  stepper3.setCurrentPosition(pos[2]);
  stepper3.setMaxSpeed(stepsPerSec);
  stepper3.setAcceleration(stepsPerSec2); 
  stepper4.setCurrentPosition(pos[3]);    
  stepper4.setMaxSpeed(stepsPerSec);
  stepper4.setAcceleration(stepsPerSec2);
  stepper5.setCurrentPosition(pos[4]);
  stepper5.setMaxSpeed(stepsPerSec);
  stepper5.setAcceleration(stepsPerSec2);
  stepper6.setCurrentPosition(pos[5]);     
  stepper6.setMaxSpeed(stepsPerSec);
  stepper6.setAcceleration(stepsPerSec2);
}

/****************** Print EE data for debug ******************/ 
void printEEdata(void)
{
  Serial.println(F("EE values are:"));
  Serial.print(F("utcOffset = "));
  Serial.println(utcOffset);
  Serial.print(F("dst = "));
  if(dst == US) Serial.println(F("US")); 
  else if(dst == MEX) Serial.println(F("MEX"));
  else Serial.println(F("NONE"));
  Serial.print(F("longitude = "));
  Serial.println(longitude);
  Serial.print(F("latitude = "));
  Serial.println(latitude);
  Serial.print(F("upTimeOffset = "));
  Serial.println(upTimeOffset);
  Serial.print(F("downTimeOffset = "));
  Serial.println(downTimeOffset);  
  Serial.println(F("shadeDownPositions (ft)"));
  for (int i=0; i<MAX_MOTORS; i++)
  {
    Serial.println(shadeDownPosition[i]);      
  }
  Serial.println(F("last shade positions (steps)"));
  for (int i=0; i<MAX_MOTORS; i++)
  {
    Serial.println(pos[i]);   
  }
  Serial.print(F("manualOption ="));
  Serial.println(manualOption);

}

void printState(void)
{
  Serial.print(F("shadecmd (0=OFF,1=DOWN,2=UP,3=UPORDOWN) = "));
  Serial.println(shadecmd);
  Serial.print(F("shadesmoving (0=NOT,1=MOT#1,2=MOT#2,etc.) = "));
  Serial.println(shadesmoving);
  Serial.print(F("state (RUN=1) = "));
  Serial.println(state);
  Serial.print(F("pos[0] ="));
  Serial.println(pos[0]);
}


  
void TestMaxStepRate(void) // for test only
{
  int Ncalls = 1000;
  int time_ms = millis();
  for (int i = 0; i < Ncalls; i++) {
    myStepper1->onestep(FORWARD, DOUBLE);
  }
  int elapsed_ms = millis() - time_ms;
  Serial.print(Ncalls / (elapsed_ms / 1000.)); Serial.print(" Steps/sec. \t");  
}

void printVoltages(void) // for test only
{
    
    Serial.print("V12 = ");
    Serial.print(c12*.01238); 
    Serial.print("  pwrMode = ");
    if(pwrMode == PRIMARY) Serial.println("PRIMARY"); else Serial.println("BACKUP");    
    Serial.print("V9 = ");
    Serial.print(c9*.009872);  
    Serial.print("  batteryState = ");
    if(batteryState == NG) Serial.println("NG"); else Serial.println("OK");
}



void loop() 
{
  
/*********** Do these tasks continuously *******************************/    
  currentMillis = millis(); 
  if(shadecmd == OFF) buttons = lcd.readButtons();
  c12 = analogRead(v12Pin); // volts = c12 * .01238
  c9 = analogRead(v9Pin);   // volts = c9 * .009872 
     
/***** for testing  Note: serial adds about 4% to program storage size  
  if(Serial.available()) 
    {
      incomingByte = Serial.read();
      if(incomingByte == 'D') 
      {
        //readEEdata();
        //printEEdata();
        //printState();
        //printVoltages();
      }      
    }
**********/   
    
/************* Every second, read the RTC and update time variables ********************/    
  if (((currentMillis - previousMillis) >= 1000)) 
  { 
    previousMillis = currentMillis;
    if(++hb > 1) hb = 0;
    digitalWrite(LED, hb);
    if(state == RUN)
    {
      now = rtc.now();
      currentYear = now.year(); currentMonth = now.month(); currentDay = now.day(); currentHour = now.hour(); currentMin = now.minute(); 
      currentDow = now.dayOfTheWeek(); currentSec = now.second();
    }
    
    //printVoltages(); //for test only
    
  }

/*********** Every midnight, recalc the sunset time. Do before minute ck for correct suntime on startup ****************/    
  if ((currentDay != previousDay) && (state == RUN)) 
  {
     previousDay = currentDay;
     CalcSunTime();
  }
  
/*************** Every minute, update the default diaplay *********************/
  if ((currentMin != previousMin) && (state == RUN) && (shadecmd == OFF)) 
  {
    previousMin = currentMin;
    updateDefaultDisplay(); 
    currentTimeInMin = (float) 60*currentHour + currentMin;    
  }
  

/************* Flash the 12 VDC warning in BACKUP ****************/
 if((pwrMode == BACKUP) && (state == RUN))
 {
  if((period1 == OFF) && (currentSec%5 == 0))
  {
    period1 = ON;
    lcd.clear();
    lcd.setCursor(0,0); 
    lcd.setBacklight(RED);
    lcd.print(F("Check 12V"));   
  }
  if((period1 == ON) && (currentSec%5 == 4))
  {
    period1 = OFF;
    updateDefaultDisplay(); 
  }
 }

/************* Flash the 9 VDC warning if NG ****************/
 if((batteryState == NG) && (state == RUN) && (shadesmoving == NOTMOVING))
 {
  if((period2 == OFF) && (currentSec%5 == 0))
  {
    period2 = ON;
    lcd.clear();
    lcd.setCursor(0,0); 
    lcd.setBacklight(RED);
    lcd.print(F("Replace 9V Bat"));   
  }
  if((period2 == ON) && (currentSec%5 == 4))
  {
    period2 = OFF;
    updateDefaultDisplay(); 
  }
 }
     
/***** Every 2am, check if DST went in or out of effect, then adjust hour and utcOffset. ****/     
  if ((currentDay != priorDay) && (currentHour==2) && (currentMin==0) && (state == RUN)) 
  {   
    DSTtimeShift();
    priorDay = currentDay;  
  }
    
/******************* After 60 seconds of no button activity, revert to RUN state  **********************/
  if((state != RUN) && (currentMillis - lastbuttonMillis >= 60000)) 
  {
    state = RUN;
  } 
  
/***************** When a button is pressed, process it *********************/      
  if (buttons && (shadesmoving == NOTMOVING)) //ignore buttons if shades are moving
  { 
    lastbuttonMillis = currentMillis;    
    delay(400); // to slow autorepeat if button held
    ProcessButtons();
  }    

/********************* If 12vdc power is low, save the positions to EE and stop moving ************/
/** Note the logic keeps stepping even if the motor power is removed ***/
/** Note since only 1 motor runs at the same time, only 1 motor will be energized by the following **/
/** Check for this condition continuously and act immediately to avoid losing track of positions if power fails **/
 if ((c12 < 727) && (pwrMode == PRIMARY)) // v12 < 9 vdc
 {
   pos[0] = stepper1.currentPosition(); // read position in logic ASAP
   stepper1.runToNewPosition(pos[0]); // and tell motor logic to stay there 
      
   pos[1] = stepper2.currentPosition(); 
   stepper2.runToNewPosition(pos[1]); 
     
   pos[2] = stepper3.currentPosition(); 
   stepper3.runToNewPosition(pos[2]); 
    
   pos[3] = stepper4.currentPosition(); 
   stepper4.runToNewPosition(pos[3]);
     
   pos[4] = stepper5.currentPosition(); 
   stepper5.runToNewPosition(pos[4]); 
    
   pos[5] = stepper6.currentPosition(); 
   stepper6.runToNewPosition(pos[5]);
    
   myStepper1->release(); // disable outputs in case 12VDC is just low but not off
   myStepper2->release();
   myStepper3->release();
   myStepper4->release();
   myStepper5->release();
   myStepper6->release();

   for (int i=0; i<MAX_MOTORS; i++)
   {
     SaveEEint(pos[i], EEadr_pos[i]); // save to EE in case battery dies
   }
      
   pwrMode = BACKUP;
  
   shadecmd = OFF;
   shadesmoving = NOTMOVING;

 // halt time measured < 1 msec (< 1 step at 300 steps/sec)
 //Serial.print("Halt time = ");
 //Serial.println(t2-t1);  
 }
 
 /********** If 12vdc returns, put shades all up *************/
 if ((c12 > 808) && (pwrMode == BACKUP)) //v12 > 10 vdc
 {
   pwrMode = PRIMARY; 
   updateDefaultDisplay(); 
      
   if(pos[0]||pos[1]||pos[2]||pos[3]||pos[4]||pos[5]) // at least one shade is not UP
   {
     shadecmd = UP;     
   }
 }
 
/************** If 9vdc low, battery needs to be replaced *********/
/************* Do not run these tests when motors are moving *****/
/********** A fresh MN1604 battery should supply 100 mA for about 3 hours before dropping to 7 vdc ******/
 if ((c9 < 709) && (batteryState ==OK) && (shadesmoving == NOTMOVING)) //v9 < 7vdc
 {
    batteryState = NG;
 }

/************** If 9vdc returns, battery is OK ****/ 
  if ((c9 > 810) && (batteryState == NG) && (shadesmoving == NOTMOVING)) //v9 > 8vdc
  {
    batteryState = OK;
    updateDefaultDisplay(); 
  }
 


/******************* Check if time to raise or lower the shades ********************/  
 
  if((currentTimeInMin == uptime) && (currentTimeInMin != previousTimeInMin) && (batteryState == OK))
  {
    shadecmd = UP;
    previousTimeInMin = currentTimeInMin; 
    lcd.clear();
    lcd.setCursor(0,0); 
    lcd.setBacklight(YELLOW);
    lcd.print(F("Timer Command"));
    setTargetPositions(ALL);  
  }
   if((currentTimeInMin == downtime) && (currentTimeInMin != previousTimeInMin) && (downtime != uptime) && (batteryState == OK))
  {  
    shadecmd = DOWN;
    previousTimeInMin = currentTimeInMin;
    lcd.clear();
    lcd.setCursor(0,0); 
    lcd.setBacklight(YELLOW);
    lcd.print(F("Timer Command")); 
    setTargetPositions(ALL);
  }
    
/***************** Raise on Reset  ***********************/
  if(needToRaise)
  {
    shadecmd = UP;
    lcd.clear();
    lcd.setCursor(0,0); 
    lcd.setBacklight(YELLOW);
    lcd.print(F("Raise All Shades")); 
    setTargetPositions(ALL);    
    needToRaise = 0;
  }
  

/************** Run the motors sequentially *********/  
  if(shadecmd > 0)
  {
    switch(shadesmoving)
    {
    case NOTMOVING:
      shadesmoving = MOTOR1;
      break;
    case MOTOR1:
      if(stepper1.distanceToGo() != 0) stepper1.run();
      else
      {
         myStepper1->release(); 
         pos[0] = stepper1.currentPosition();
         SaveEEint(pos[0], EEadr_pos[0]);
         shadesmoving = MOTOR2;
      }
      break;
    case MOTOR2:
      if(stepper2.distanceToGo() != 0) stepper2.run();
      else
      {
        myStepper2->release();        
        pos[1] = stepper2.currentPosition();
        SaveEEint(pos[1], EEadr_pos[1]);
        shadesmoving = MOTOR3;
      }
      break;
    case MOTOR3:
      if(stepper3.distanceToGo() != 0) stepper3.run();
      else
      {
        myStepper3->release();
        pos[2] = stepper3.currentPosition();
        SaveEEint(pos[2], EEadr_pos[2]);
        shadesmoving = MOTOR4;
      }
      break;
    case MOTOR4:
      if(stepper4.distanceToGo() != 0) stepper4.run();
      else
      {
        myStepper4->release();     
        pos[3] = stepper4.currentPosition();
        SaveEEint(pos[3], EEadr_pos[3]);
        shadesmoving = MOTOR5;
      }
      break;
    case MOTOR5:
      if(stepper5.distanceToGo() != 0) stepper5.run();
      else
      {
        myStepper5->release();     
        pos[4] = stepper5.currentPosition();
        SaveEEint(pos[4], EEadr_pos[4]);
        shadesmoving = MOTOR6; 
      }
      break;
    case MOTOR6:
      if(stepper6.distanceToGo() != 0) stepper6.run();
      else
      {
        myStepper6->release();     
        pos[5] = stepper6.currentPosition();
        SaveEEint(pos[5], EEadr_pos[5]);
        shadesmoving = NOTMOVING;
        shadecmd = OFF; 
        updateDefaultDisplay(); // immediate display update
      }
      break;
    }    
  }  
} // end of (void) loop()

/***********************************************************************************************************************************/
void ProcessButtons(void)
{  

  lcd.setBacklight(GREEN);
  lcd.clear();
  lcd.setCursor(0,0); 
  //Serial.print("state = ");
  //Serial.println(state);
    
  switch (state) 
  {
    case RUN: // state#20 - Run the motors, update time, etc. 
      switch(buttons)
      {
        case BUTTON_RIGHT: state = PROGRAM_TIME; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("TIME"));  break;
        case BUTTON_LEFT: 
          if(manualOption == INDIVIDUAL)
          {
            state = MANUAL_IND; lcd.print(F("Manual Sel Shade")); lcd.setBacklight(YELLOW);
            lcd.setCursor(0,1); lcd.print(F("Shade #")); shadeno = 0; lcd.print(shadeno+1); break;
          }
          else if(manualOption == ADJUSTABLE)
          {
            state = MANUAL_ADJ; lcd.print(F("Set Shade ")); shadeno = 0; lcd.print(shadeno+1); lcd.setBacklight(YELLOW); 
            lcd.setCursor(0,1); lcd.print(F("to ")); lcd.print(shadeDownPosition[shadeno]); break;
          }
          else
          {
            lcd.print(F("Manual All")); lcd.setBacklight(YELLOW);
            if(pos[0]||pos[1]||pos[2]||pos[3]||pos[4]||pos[5]) shadecmd = UP; 
            else shadecmd = DOWN;
            setTargetPositions(ALL);
            break; 
          }
        default: updateDefaultDisplay(); break; 
      }      
      break;

    case MANUAL_IND:  // state #26 - Select a single motor to run
      lcd.print(F("Manual Sel Shade"));
      lcd.setBacklight(YELLOW);
      switch(buttons)
      {
        case BUTTON_SELECT: if(pos[shadeno] > 0) shadecmd = UP; else shadecmd = DOWN; setTargetPositions(INDIVIDUAL); state = RUN; break;
        case BUTTON_LEFT: lcd.setCursor(0,1); if(++shadeno > 5) shadeno = 0; lcd.print(F("Shade #")); lcd.print(shadeno+1); break;
        default: state = RUN; updateDefaultDisplay(); break;         
      }
      break;

    case MANUAL_ADJ:   // Select motor with Left sw, Set new pos with Up/Dn sw, Execute motion with Sel sw, Right Sw raises all shades
      lcd.setBacklight(YELLOW);
      switch(buttons)
      {
        case BUTTON_LEFT: if(++shadeno > 5){shadeno = 0; state = RUN; updateDefaultDisplay();} 
            else{lcd.print(F("Adj Shade ")); lcd.print(shadeno+1);  
            lcd.setCursor(0,1); lcd.print(F("to ")); lcd.print(shadeDownPosition[shadeno]);} break;
        case BUTTON_RIGHT: needToRaise = 1; state = RUN; updateDefaultDisplay(); break;
        default: lcd.print(F("Adj Shade ")); lcd.print(shadeno+1); lcd.setCursor(0,1); lcd.print(F("to ")); setFloatVariable(buttons,shadeDownPosition[shadeno],EEadr_shadeDownPosition[shadeno],0.0,12,pres,NO);
                 if(buttons == BUTTON_SELECT) {shadecmd = DOWN; setTargetPositions(ALL); state = RUN; lcd.setCursor(0,0); lcd.print(F("Adjust Shades"));} break; //UP, DOWN & SET
      }
      break;  
       
    case PROGRAM_TIME: // state#31 - Select Time parameters for programming     
      switch(buttons)
      {
        case BUTTON_UP: state = PROGRAM_LOCATION; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("LOCATION")); break;
        case BUTTON_DOWN: state = PROGRAM_OPTIONS; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("OPTIONS")); break;
        case BUTTON_LEFT: state = RUN; updateDefaultDisplay(); break;
        case BUTTON_RIGHT: state = SET_YEAR; lcd.print(F("SET YEAR")); lcd.setCursor(0,1); lcd.print(currentYear); break;
        default: break;
      }
      break; 
   
    case SET_YEAR: // state#2 - Set Year 2017 to 2050
      switch(buttons)
      {
        case BUTTON_LEFT: state = PROGRAM_TIME; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("TIME")); break;
        case BUTTON_RIGHT: state = SET_MONTH; lcd.print(F("SET MONTH")); lcd.setCursor(0,1); lcd.print(currentMonth); break;
        default: lcd.print(F("SET YEAR")); setTimeVariable(buttons,currentYear,2017,2050,1); break; //UP, DOWN & SET
      }
      break;  
      
    case SET_MONTH: // state#3 - Set Month 1 to 12 
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_YEAR; lcd.print(F("SET YEAR")); lcd.setCursor(0,1); lcd.print(currentYear); break;
        case BUTTON_RIGHT: maxDays=MaxDays(currentMonth); state = SET_DAY; lcd.print(F("SET DAY"));  lcd.setCursor(0,1); lcd.print(currentDay); break;
        default: lcd.print(F("SET MONTH")); setTimeVariable(buttons,currentMonth,1,12,1); break; //UP, DOWN & SET
      }
      break;     
      
    case SET_DAY: // state#4 - Set Day 1 to 31
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_MONTH; lcd.print(F("SET MONTH")); lcd.setCursor(0,1); lcd.print(currentMonth); break;
        case BUTTON_RIGHT: state = SET_HOUR; lcd.print(F("SET HOUR")); lcd.setCursor(0,1); lcd.print(currentHour);  break;
        default: lcd.print(F("SET DAY")); setTimeVariable(buttons,currentDay,1,maxDays,1); break; //UP, DOWN & SET
      }
      break;  
      
    case SET_HOUR: // state#5 - Set Hour 0 to 23
      switch(buttons)
      {
        case BUTTON_LEFT: maxDays=MaxDays(currentMonth); state = SET_DAY; lcd.print(F("SET DAY")); lcd.setCursor(0,1); lcd.print(currentDay); break;
        case BUTTON_RIGHT: state = SET_MINUTE; lcd.print(F("SET MINUTE")); lcd.setCursor(0,1); lcd.print(currentMin); break;
        default: lcd.print(F("SET HOUR")); setTimeVariable(buttons,currentHour,0,23,1); break; //UP, DOWN & SET
      }
      break; 
       
    case SET_MINUTE: // state#6 - Set Minutes 0 to 59
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_HOUR; lcd.print(F("SET HOUR")); lcd.setCursor(0,1); lcd.print(currentHour); break;
        case BUTTON_RIGHT: state = SET_UTC_OFFSET; lcd.print(F("SET UTC OFFSET")); lcd.setCursor(0,1); lcd.print(utcOffset); break;
        default: lcd.print(F("SET MINUTE")); setTimeVariable(buttons,currentMin,0,59,1); break; //UP, DOWN & SET
      }
      break;  
        
    case SET_UTC_OFFSET: // state#7 - Set UTC offset -11 to +12
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_MINUTE; lcd.print(F("SET MINUTE")); lcd.setCursor(0,1); lcd.print(currentMin); break;
        case BUTTON_RIGHT: state = SET_DST; lcd.print(F("SET DST")); lcd.setCursor(0,1); LCDdst(dst); break;
        default: lcd.print(F("SET UTC OFFSET")); setTimeVariable(buttons,utcOffset,-11,12,1); break; //UP, DOWN & SET
      }
      break;  
      
    case SET_DST: // state#8 - Set DST 0 to 2 => US, Mex, No
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_UTC_OFFSET; lcd.print(F("SET UTC OFFSET")); lcd.setCursor(0,1); lcd.print(utcOffset); break;
        case BUTTON_RIGHT: state = PROGRAM_TIME; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("TIME")); break;
        default: lcd.print(F("SET DST")); setIntTextVariable(buttons,dst,EEadr_dst,0,2,1); break; //UP, DOWN & SET
      }
      break;

    case PROGRAM_LOCATION: // state#32 - Select Location parameters for programming     
      switch(buttons)
      {
        case BUTTON_UP: state = PROGRAM_SHADES; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("SHADE")); break;
        case BUTTON_DOWN: state = PROGRAM_TIME; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("TIME")); break;
        case BUTTON_LEFT: state = RUN; updateDefaultDisplay(); break;
        case BUTTON_RIGHT: state = SET_LONGITUDE; lcd.print(F("SET LONGITUDE")); lcd.setCursor(0,1); lcd.print(longitude); break;
        default: break;
      }
      break; 
      
    case SET_LONGITUDE: // state#9 - Set Longitude -179 to +179 
      switch(buttons)
      {
        case BUTTON_LEFT: state = PROGRAM_LOCATION; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("LOCATION")); break;
        case BUTTON_RIGHT: state = SET_LATITUDE; lcd.print(F("SET LATITUDE")); lcd.setCursor(0,1); lcd.print(latitude);  break;
        default: lcd.print(F("SET LONGITUDE")); setIntegerVariable(buttons,longitude,EEadr_longitude,-179,179,1); break; //UP, DOWN & SET
      }
      break;        
       
    case SET_LATITUDE: // state#10 - Set Latitude -64 to +64
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_LONGITUDE; lcd.print(F("SET LONGITUDE")); lcd.setCursor(0,1); lcd.print(longitude);  break;
        case BUTTON_RIGHT: state = PROGRAM_LOCATION; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("LOCATION")); break;
        default: lcd.print(F("SET LATITUDE")); setIntegerVariable(buttons,latitude,EEadr_latitude,-64,64,1); break; //UP, DOWN & SET
      }
      break;
     
    case PROGRAM_SHADES: // state#33 - Select Shade parameters for programming     
      switch(buttons)
      {
        case BUTTON_UP: state = PROGRAM_ZEROSET; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("ZEROSET")); break;
        case BUTTON_DOWN: state = PROGRAM_LOCATION; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("LOCATION")); break;
        case BUTTON_LEFT: state = RUN; updateDefaultDisplay(); break;
        case BUTTON_RIGHT: state = SET_UPTIMEOFFSET; lcd.print(F("SET UPTIMEOFFSET")); lcd.setCursor(3,1); lcd.print(upTimeOffset); break;
        default: break;
      }
      break; 

    
    case SET_UPTIMEOFFSET: // Set upTimeOffset in quarter hour steps, -8.0 to +8.0 hours. Neg or 0 means before sunset. Pos is after sunrise. 
      switch(buttons)
      {
        case BUTTON_LEFT: state = PROGRAM_SHADES; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("SHADES")); break;
        case BUTTON_RIGHT: state = SET_DNTIMEOFFSET; lcd.print(F("SET DNTIMEOFFSET")); lcd.setCursor(3,1); DownTimeLimits(); lcd.print(downTimeOffset); break;
        default: lcd.print(F("SET UPTIMEOFFSET")); setFloatVariable(buttons,upTimeOffset,EEadr_upTimeOffset,-8.0,8.0,0.25,YES); break; //UP, DOWN & SET
      }
      break; 
      
    case SET_DNTIMEOFFSET: // Set downTimeOffset in quarter hour steps, -8.0 to (upTimeOffset) hours. Neg is before sunset. Pos is after sunrise.
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_UPTIMEOFFSET; lcd.print(F("SET UPTIMEOFFSET")); lcd.setCursor(3,1); lcd.print(upTimeOffset); break;
        case BUTTON_RIGHT: state = SET_SHADE1_DOWN; lcd.print(F("SET SHADE1 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[0]); break;
        default: lcd.print(F("SET DNTIMEOFFSET")); setFloatVariable(buttons,downTimeOffset,EEadr_downTimeOffset,minDownTimeOffset,maxDownTimeOffset,0.25,YES);  break; //UP, DOWN & SET
      }
      break;      
 
    case SET_SHADE1_DOWN: // state#13 - Set shade1DownPosition, 0.0 to 12 feet
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_DNTIMEOFFSET; lcd.print(F("SET DNTIMEOFFSET")); lcd.setCursor(3,1); DownTimeLimits(); lcd.print(downTimeOffset); break;
        case BUTTON_RIGHT: state = SET_SHADE2_DOWN; lcd.print(F("SET SHADE2 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[1]); break;
        default: lcd.print(F("SET SHADE1 DOWN")); setFloatVariable(buttons,shadeDownPosition[0],EEadr_shadeDownPosition[0],0.0,12,pres,YES); break; //UP, DOWN & SET
      }
      break;  
                                   \
    case SET_SHADE2_DOWN: // state#14 - Set shade2DownPosition, 0.0 to 12 feet
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_SHADE1_DOWN; lcd.print(F("SET SHADE1 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[0]); break;
        case BUTTON_RIGHT: state = SET_SHADE3_DOWN; lcd.print(F("SET SHADE3 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[2]); break;
        default: lcd.print(F("SET SHADE2 DOWN")); setFloatVariable(buttons,shadeDownPosition[1],EEadr_shadeDownPosition[1],0.0,12,pres,YES); break;    //UP, DOWN & SET
      }
      break;   
             
    case SET_SHADE3_DOWN: // state#15 - Set shade3DownPosition, 0.0 to 12 feet
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_SHADE2_DOWN; lcd.print(F("SET SHADE2 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[1]); break;
        case BUTTON_RIGHT: state = SET_SHADE4_DOWN; lcd.print(F("SET SHADE4 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[3]); break;
        default: lcd.print(F("SET SHADE3 DOWN")); setFloatVariable(buttons,shadeDownPosition[2],EEadr_shadeDownPosition[2],0.0,12,pres,YES); break;    //UP, DOWN & SET
      } 
      break;
          
    case SET_SHADE4_DOWN: // state#16 - Set shade4DownPosition, 0.0 to 12 feet
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_SHADE3_DOWN; lcd.print(F("SET SHADE3 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[2]); break;
        case BUTTON_RIGHT: state = SET_SHADE5_DOWN; lcd.print(F("SET SHADE5 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[4]); break;
        default: lcd.print(F("SET SHADE4 DOWN")); setFloatVariable(buttons,shadeDownPosition[3],EEadr_shadeDownPosition[3],0.0,12,pres,YES); break;    //UP, DOWN & SET
      }  
      break;  
     
    case SET_SHADE5_DOWN: // state#17 - Set shade5DownPosition, 0.0 to 12 feet
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_SHADE4_DOWN; lcd.print(F("SET SHADE4 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[3]); break;
        case BUTTON_RIGHT: state = SET_SHADE6_DOWN; lcd.print(F("SET SHADE6 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[5]); break;
        default: lcd.print(F("SET SHADE5 DOWN")); setFloatVariable(buttons,shadeDownPosition[4],EEadr_shadeDownPosition[4],0.0,12,pres,YES); break;     //UP, DOWN & SET
      }  
      break;   
      
    case SET_SHADE6_DOWN: // state#18 - Set shade6DownPosition, 0.0 to 12 feet
      switch(buttons)
      {
        case BUTTON_LEFT: state = SET_SHADE5_DOWN; lcd.print(F("SET SHADE5 DOWN")); lcd.setCursor(3,1); lcd.print(shadeDownPosition[4]); break;
        case BUTTON_RIGHT: state = PROGRAM_SHADES; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("SHADES")); break; 
        default: lcd.print(F("SET SHADE6 DOWN")); setFloatVariable(buttons,shadeDownPosition[5],EEadr_shadeDownPosition[5],0.0,12,pres,YES); break;     //UP, DOWN & SET
      } 
      break; 

    case SET_MANUAL_OPTION: //state#30 - Set manualOption, ALL,INDIVIDUAL or ADJUSTABLE
      switch(buttons)
      {
        case BUTTON_LEFT: state = PROGRAM_OPTIONS; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("OPTIONS")); break;
        case BUTTON_RIGHT: state = SET_POS_RES; lcd.print(F("SET POS RESOL")); lcd.setCursor(0,1); lcd.print(pres); break;
        default: lcd.print(F("SET MAN OPTION")); setIntTextVariable(buttons,manualOption,EEadr_manualOption,0,2,1); break;     //UP, DOWN & SET
      } 
      break; 

    case SET_POS_RES: //state#33 - Set position resolution, .25 to 1.00 foot
     switch(buttons)
      {
        case BUTTON_LEFT: state = SET_MANUAL_OPTION; lcd.print(F("SET MAN OPTION")); lcd.setCursor(3,1); LCDopt(manualOption); break; 
        case BUTTON_RIGHT: state = PROGRAM_OPTIONS; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("OPTIONS")); break;
        default: lcd.print(F("SET POS RESOL")); setFloatVariable(buttons,pres,EEadr_pres,0.25,1.0,0.25,YES); break; //UP, DOWN & SET
      }
      break; 

     case PROGRAM_OPTIONS: //state#32
      switch(buttons)
      {
        case BUTTON_UP: state = PROGRAM_TIME; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("TIME")); break;
        case BUTTON_DOWN: state = PROGRAM_ZEROSET; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("ZEROSET")); break; 
        case BUTTON_LEFT: state = RUN; updateDefaultDisplay(); break;
        case BUTTON_RIGHT: state = SET_MANUAL_OPTION; lcd.print(F("SET MAN OPTION")); lcd.setCursor(3,1); LCDopt(manualOption); break; 
        default: break;
      }
      break;
       
     case PROGRAM_ZEROSET: // state#28 - Select up (zero) positions of the shades   
      switch(buttons)
      {
        case BUTTON_UP: state = PROGRAM_OPTIONS; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("OPTIONS")); break;
        case BUTTON_DOWN: state = PROGRAM_SHADES; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("SHADES")); break;
        case BUTTON_LEFT: state = RUN; updateDefaultDisplay(); break;
        case BUTTON_RIGHT: state = SET_SHADE1_UP; lcd.print(F("SET SHADE1 UP")); LCDclearLine2(); break;
        default: break;
      }
      break; 
     
    case SET_SHADE1_UP: // state#21 - Set the up (zero) position of shade #1
      switch(buttons)
      {                 
        case BUTTON_UP:   LCDmoveMsg(1, UP); Jog1(UP,JOG); break;
        case BUTTON_DOWN: LCDmoveMsg(1, DOWN); Jog1(DOWN,JOG); break;  
        case BUTTON_LEFT: state = PROGRAM_ZEROSET;  lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("ZEROSET")); break;
        case BUTTON_RIGHT: state = SET_SHADE2_UP; lcd.print(F("SET SHADE2 UP")); LCDclearLine2(); break;
        default: break;
      }  
      break;

    case SET_SHADE2_UP: // state#22 - Set the up (zero) position of shade #2
      switch(buttons)
      {                 
        case BUTTON_UP:   LCDmoveMsg(2, UP); Jog2(UP,JOG); break;
        case BUTTON_DOWN: LCDmoveMsg(2, DOWN); Jog2(DOWN,JOG); break;  
        case BUTTON_LEFT:  state = SET_SHADE1_UP; lcd.print(F("SET SHADE1 UP")); LCDclearLine2(); break;
        case BUTTON_RIGHT: state = SET_SHADE3_UP; lcd.print(F("SET SHADE3 UP")); LCDclearLine2(); break;
        default: break;
      }  
      break;
      
    case SET_SHADE3_UP: // state#23 - Set the up (zero) position of shade #3
      switch(buttons)
      {                 
        case BUTTON_UP:   LCDmoveMsg(3, UP); Jog3(UP,JOG); break;
        case BUTTON_DOWN: LCDmoveMsg(3, DOWN); Jog3(DOWN,JOG); break;  
        case BUTTON_LEFT:  state = SET_SHADE2_UP; lcd.print(F("SET SHADE2 UP")); LCDclearLine2(); break;
        case BUTTON_RIGHT: state = SET_SHADE4_UP; lcd.print(F("SET SHADE4 UP")); LCDclearLine2(); break;
        default: break;
      }  
      break;     
      
    case SET_SHADE4_UP: // state#24 - Set the up (zero) position of shade #4
      switch(buttons)
      {                 
        case BUTTON_UP:   LCDmoveMsg(4, UP); Jog4(UP,JOG); break;
        case BUTTON_DOWN: LCDmoveMsg(4, DOWN); Jog4(DOWN,JOG); break;  
        case BUTTON_LEFT:  state = SET_SHADE3_UP; lcd.print(F("SET SHADE3 UP")); LCDclearLine2(); break;
        case BUTTON_RIGHT: state = SET_SHADE5_UP; lcd.print(F("SET SHADE5 UP")); LCDclearLine2(); break;
        default: break;
      }  
      break;

    case SET_SHADE5_UP: // state#25 - Set the up (zero) position of shade #5
      switch(buttons)
      {                 
        case BUTTON_UP:   LCDmoveMsg(5, UP); Jog5(UP,JOG); break;
        case BUTTON_DOWN: LCDmoveMsg(5, DOWN); Jog5(DOWN,JOG); break;  
        case BUTTON_LEFT:  state = SET_SHADE4_UP; lcd.print(F("SET SHADE4 UP")); LCDclearLine2(); break;
        case BUTTON_RIGHT: state = SET_SHADE6_UP; lcd.print(F("SET SHADE6 UP")); LCDclearLine2(); break;
        default: break;
      }  
      break;

    case SET_SHADE6_UP: // state#26 - Set the up (zero) position of shade #6
      switch(buttons)
      {                 
        case BUTTON_UP:   LCDmoveMsg(6, UP); Jog6(UP,JOG); break;
        case BUTTON_DOWN: LCDmoveMsg(6, DOWN); Jog6(DOWN,JOG); break;  
        case BUTTON_LEFT:  state = SET_SHADE5_UP; lcd.print(F("SET SHADE5 UP")); LCDclearLine2(); break;
        case BUTTON_RIGHT: state = PROGRAM_ZEROSET; lcd.print(F("PROGRAM")); lcd.setCursor(0,1); lcd.print(F("ZEROSET")); break;
        default: break;
      }  
      break;
      
    default: 
      state = RUN;
      updateDefaultDisplay();
      break;    
    break;
  }   
}

int MaxDays(int m)
  {
    int DaysInMonth[12] = {31,28,31,30,31,30,31,31,30,31,30,31}; // does not work for Feb in leap years
    return DaysInMonth[m-1];
  }
  
void DownTimeLimits(void)
  {   
    maxDownTimeOffset = upTimeOffset -0;
    if(upTimeOffset<=0) minDownTimeOffset=-8;
    else minDownTimeOffset=0;
    downTimeOffset = max(downTimeOffset, minDownTimeOffset);
    downTimeOffset = min(downTimeOffset, maxDownTimeOffset); 
  } 
     
void Jog1(int dir, int steps)
{
  if(dir == UP) stepper1.runToNewPosition(-steps);    
  else  stepper1.runToNewPosition(+steps); 
  stepper1.setCurrentPosition(0);                           
  stepper1.runToNewPosition(0); 
  myStepper1->release(); 
  pos[0] = 0; 
  LCDclearLine2();  
}

void Jog2(int dir, int steps)
{
  if(dir == UP) stepper2.runToNewPosition(-steps);    
  else  stepper2.runToNewPosition(+steps); 
  stepper2.setCurrentPosition(0);                           
  stepper2.runToNewPosition(0); 
  myStepper2->release(); 
  pos[1] = 0; 
  LCDclearLine2();  
}

void Jog3(int dir, int steps)
{
  if(dir == UP) stepper3.runToNewPosition(-steps);    
  else  stepper3.runToNewPosition(+steps); 
  stepper3.setCurrentPosition(0);                           
  stepper3.runToNewPosition(0); 
  myStepper3->release(); 
  pos[2] = 0; 
  LCDclearLine2();  
}

void Jog4(int dir, int steps)
{
  if(dir == UP) stepper4.runToNewPosition(-steps);    
  else  stepper4.runToNewPosition(+steps); 
  stepper4.setCurrentPosition(0);                           
  stepper4.runToNewPosition(0); 
  myStepper4->release(); 
  pos[3] = 0; 
  LCDclearLine2();  
}

void Jog5(int dir, int steps)
{
  if(dir == UP) stepper5.runToNewPosition(-steps);    
  else  stepper5.runToNewPosition(+steps); 
  stepper5.setCurrentPosition(0);                           
  stepper5.runToNewPosition(0); 
  myStepper5->release(); 
  pos[4] = 0; 
  LCDclearLine2();  
}

void Jog6(int dir, int steps)
{
  if(dir == UP) stepper6.runToNewPosition(-steps);    
  else  stepper6.runToNewPosition(+steps); 
  stepper6.setCurrentPosition(0);                           
  stepper6.runToNewPosition(0); 
  myStepper6->release(); 
  pos[5] = 0; 
  LCDclearLine2();  
}

void LCDmoveMsg(int m,int dir)
{
  lcd.setCursor(0,0); 
  lcd.print(F("SET SHADE"));
  lcd.print(m);
  lcd.print(F(" UP")); 
  lcd.setCursor(0,1); 
  if(dir == UP) lcd.print(F("Moving Up"));
  else if(dir == DOWN) lcd.print(F("Moving Dn"));
}

void LCDclearLine2(void)
{
  lcd.setCursor(0,1);
  lcd.print(F("                "));
}

void LCDdst(int m) 
{  
   switch (m)
   {
     case 0: lcd.print(F("US DST")); break;
     case 1: lcd.print(F("Mex DST")); break;
     case 2: lcd.print(F("No DST")); break;
   }    
}

void LCDopt(int m) 
{  
   switch (m)
   {
     case 0: lcd.print(F("All")); break;
     case 1: lcd.print(F("Individual")); break;
     case 2: lcd.print(F("Adjustable")); break;
   }    
}

void LCDmode(int8_t m)
{
  switch (m)
  {     
    case 0: lcd.print(F("Time")); break;
    case 1: lcd.print(F("Location")); break;
    case 2: lcd.print(F("Shades")); break; 
    case 3: lcd.print(F("Zeroset")); break;             
  }   
}

/********* Save and retrieve an integer x to EEprom at address EEadr_Variable & EEadr_Variable+1 *************/
void SaveEEint(int x, int EEadr_Variable)
{ 
  byte lowByte = ((x >> 0) & 0xFF);
  byte highByte = ((x >> 8) & 0xFF); 
  EEPROM.update(EEadr_Variable  , lowByte); 
  EEPROM.update(EEadr_Variable +1, highByte);
}

int GetEEint(int EEadr_Variable)
{
   byte lowByte = EEPROM.read(EEadr_Variable);
   byte highByte = EEPROM.read(EEadr_Variable +1);
   return ((lowByte << 0) & 0xFF) + ((highByte << 8) & 0xFF00);
}

void setTimeVariable(int8_t buttons,int &myVariable,int minValue,int maxValue,int incrValue)
{
  lcd.setCursor(0,1);
  switch(buttons)
  {
    case BUTTON_SELECT: rtc.adjust(DateTime(currentYear,currentMonth,currentDay,currentHour,currentMin,0)); SaveEEint(utcOffset,EEadr_utcOffset); 
                        previousTimeInMin = 0; CalcSunTime(); lcd.setBacklight(GREEN); lcd.print(myVariable); break;
    case BUTTON_UP: lcd.setBacklight(RED); myVariable = min(myVariable+incrValue, maxValue); lcd.print(myVariable); break;
    case BUTTON_DOWN: lcd.setBacklight(RED); myVariable = max(myVariable-incrValue, minValue); lcd.print(myVariable); break;
  }
}     

void setIntegerVariable(int8_t buttons,int &myVariable,int EEadr_Variable,int minValue,int maxValue,int incrValue)
{
   lcd.setCursor(0,1);
   switch(buttons)
   {
     case BUTTON_SELECT: SaveEEint(myVariable,EEadr_Variable); setStepperSpeedAccel(); CalcSunTime(); lcd.setBacklight(GREEN); lcd.print(myVariable); break;
     case BUTTON_UP: lcd.setBacklight(RED); myVariable = min(myVariable+incrValue, maxValue); lcd.print(myVariable); break;
     case BUTTON_DOWN: lcd.setBacklight(RED); myVariable = max(myVariable-incrValue, minValue) ; lcd.print(myVariable); break;
   }
}         

void setFloatVariable(int8_t buttons,float &myVariable,int EEadr_Variable, float minValue,float maxValue,float incrValue,int save)
{
   lcd.setCursor(3,1);
   switch(buttons)
   {
     case BUTTON_SELECT: if(save == YES) SaveEEint((int) 4*myVariable,EEadr_Variable); CalcShadeTimes(); lcd.setBacklight(GREEN); lcd.print(myVariable); break;     
     case BUTTON_UP: lcd.setBacklight(RED); myVariable = min(myVariable+incrValue, maxValue); lcd.print(myVariable); break;
     case BUTTON_DOWN: lcd.setBacklight(RED); myVariable = max(myVariable-incrValue, minValue); lcd.print(myVariable); break;
   }
} 

void setIntTextVariable(int8_t buttons,int &myVariable,int EEadr_Variable,int minValue,int maxValue,int incrValue)  
{
  lcd.setCursor(0,1);
  switch(buttons)
  {
    case BUTTON_SELECT: SaveEEint((int) myVariable,EEadr_Variable); lcd.setBacklight(GREEN); if(&myVariable==&dst) LCDdst(myVariable); else LCDopt(myVariable); break;
    case BUTTON_UP: lcd.setBacklight(RED); myVariable = min(myVariable+incrValue, maxValue); if(&myVariable==&dst) LCDdst(myVariable); else LCDopt(myVariable); break;
    case BUTTON_DOWN: lcd.setBacklight(RED);  myVariable = max(myVariable-incrValue, minValue); if(&myVariable==&dst) LCDdst(myVariable); else LCDopt(myVariable); break;
  } 
}

void updateDefaultDisplay(void)
{ 
    lcd.setCursor(0,0); 
    lcd.setBacklight(WHITE);
    if(currentMonth<10) lcd.print("0");
    lcd.print(currentMonth);      
    lcd.print("/");
    if(currentDay<10) lcd.print("0"); 
    lcd.print(currentDay);     
    lcd.print("/");
    lcd.print(currentYear);
    lcd.print(" ");
    if(currentHour<10) lcd.print("0"); 
    lcd.print(currentHour);     
    lcd.print(":");
    if(currentMin<10) lcd.print("0"); 
    lcd.print(currentMin); 
    LCDclearLine2(); 
    lcd.setCursor(0,1);
    if(upTimeOffset<=0)
    {
      lcd.print("Sunset at "); 
      if(sunsethour<10) lcd.print("0"); 
      lcd.print(sunsethour);        
      lcd.print(":");
      if(sunsetmin<10) lcd.print("0"); 
      lcd.print(sunsetmin);
    }  
    else
    {
      lcd.print("Sunrise at "); 
      if(sunrisehour<10) lcd.print("0"); 
      lcd.print(sunrisehour);        
      lcd.print(":");
      if(sunrisemin<10) lcd.print("0"); 
      lcd.print(sunrisemin);
    }  
}

/********** Calculate the time of sunset & sunrise from lat, long, utcOffset, month and day *******************/     
void CalcSunTime(void)
{
  TimeLord tardis; 
  tardis.TimeZone(60*utcOffset); // tell TimeLord what timezone your RTC is synchronized to.
  tardis.Position(latitude, longitude); // tell TimeLord where in the world we are
  byte bday = currentDay;
  byte bmonth = currentMonth;
  byte today[] = {0,0,12,bday,bmonth,0}; // tell TimeLord today's date (at noon) in an array: s,m,h,d,m,y. Only the day and month matter.    
  tardis.SunSet(today);
  sunsethour = (int) today[tl_hour];
  sunsetmin = (int) today[tl_minute];
  tardis.SunRise(today);
  sunrisehour = (int) today[tl_hour];
  sunrisemin = (int) today[tl_minute];
  CalcShadeTimes();
}

/************** Compare dst for today with dst for yesterday to see if clocks should change *************/
void DSTtimeShift(void)
{
  DateTime yesterday(now-TimeSpan(1,0,0,0));
  int yday; int ymonth; int ydow;
  yday = yesterday.day(); ymonth = yesterday.month(); ydow = yesterday.dayOfTheWeek(); 
  switch (dst)
  {
    case US:  dstoffset = IsUSDST(currentDay, currentMonth, currentDow); olddstoffset = IsUSDST(yday, ymonth, ydow); break;
    case MEX: dstoffset = IsMXDST(currentDay, currentMonth, currentDow); olddstoffset = IsMXDST(yday, ymonth, ydow); break; 
    case NONE:  dstoffset = 0; olddstoffset = 0; break;  
  }
  if((dstoffset - olddstoffset) == 1)  //we just went on DST
  { 
    currentHour++; rtc.adjust(DateTime(currentYear,currentMonth,currentDay,currentHour,currentMin,0));
    utcOffset++; SaveEEint(utcOffset,EEadr_utcOffset); CalcSunTime(); 
  }
  else if(((dstoffset - olddstoffset) == -1)) // we just went off DST
  {
    currentHour--; rtc.adjust(DateTime(currentYear,currentMonth,currentDay,currentHour,currentMin,0));
    utcOffset--; SaveEEint(utcOffset,EEadr_utcOffset); CalcSunTime();       
  }        
}

/*** US DST Calculation. USDST starts on the second Sunday of March and ends on the first Sunday of November, at 2am. ***/
bool IsUSDST(int currentDay, int currentMonth, int dow)
{
  //January, february, and december are out.
  if (currentMonth < 3 || currentMonth > 11) { return false; }
  //April to October are in
  if (currentMonth > 3 && currentMonth < 11) { return true; }
  int previousSunday = currentDay - dow;
  //In march, we are DST if our previous sunday was on or after the 8th.
  if (currentMonth == 3) { return previousSunday >= 8; }
  //In november we must be before the first sunday to be dst.
  //That means the previous sunday must be before the 1st.
  return previousSunday <= 0;
}

/*** Mex DST Calculation. MXDST starts on the first Sunday in April and ends the last Sunday in October, at 2am. ****/ 
bool IsMXDST(int currentDay, int currentMonth, int dow)
{
  //November, December, January, February, March are out.
  if (currentMonth < 4 || currentMonth > 10) {return false;}
  //May to September are in.
  if (currentMonth > 4 && currentMonth < 10) {return true;}
  int previousSunday = currentDay - dow;
  // In April, we are in DST if the previous Sunday was on or after the 1st.
  if (currentMonth == 4) {return previousSunday >= 1; }
  //In October we must be before the last Sunday to be in dst.
  //That means the previous Sunday must be on or after the 25th to be out of dst.
  if(currentMonth == 10) 
  {
    if(previousSunday >= 25) {return false;}
    else {return true;}
  }
} 

void CalcShadeTimes()
{
  if(upTimeOffset <= 0)
  {
    uptime = 60*sunsethour + sunsetmin + 60*upTimeOffset; 
    downtime = 60*sunsethour + sunsetmin + 60*downTimeOffset;  
  }
  else
  {
    uptime = 60*sunrisehour + sunrisemin + 60*upTimeOffset; 
    downtime = 60*sunrisehour + sunrisemin + 60*downTimeOffset; 
  }
}

void setTargetPositions( int option)
{  
  if(shadecmd == DOWN)  
  {
    for( int i=0; i<MAX_MOTORS; i++)
    {
      down[i] = shadeDownPosition[i]*2124; // scaling is 2124 steps per ft.
    }
    lcd.setCursor(0,1);
    lcd.print(F("Moving Shade"));
    if(option == INDIVIDUAL)   
    {
      lcd.setCursor(14,1);
      lcd.print(shadeno+1);
      switch(shadeno)
      {     
        case 0:
          stepper1.moveTo(down[0]); break;
        case 1:
          stepper2.moveTo(down[1]); break;
        case 2:
          stepper3.moveTo(down[2]); break;
        case 3:
          stepper4.moveTo(down[3]); break;
        case 4:
          stepper5.moveTo(down[4]); break;
        case 5:
          stepper6.moveTo(down[5]); break;
      }
    }
    else
    {       
      lcd.setCursor(12,1); 
      lcd.print(F("s ")); 
      stepper1.moveTo(down[0]);
      stepper2.moveTo(down[1]); 
      stepper3.moveTo(down[2]);
      stepper4.moveTo(down[3]); 
      stepper5.moveTo(down[4]);
      stepper6.moveTo(down[5]); 
    }
    shadecmd = UPORDOWN;
     
       
  }   
  if(shadecmd == UP)
  {
    lcd.setCursor(0,1);
    lcd.print(F("Raising Shade "));
    if(option == INDIVIDUAL)
    {
      lcd.setCursor(14,1);
      lcd.print(shadeno+1);
     switch(shadeno)
     {
        case 0:
          stepper1.moveTo(0); break;
        case 1:
          stepper2.moveTo(0); break;
        case 2:
          stepper3.moveTo(0); break;
        case 3:
          stepper4.moveTo(0); break;
        case 4:
          stepper5.moveTo(0); break;
        case 5:
          stepper6.moveTo(0); break;
      } 
    }
    else
    {
      lcd.setCursor(13,1); 
      lcd.print(F("s ")); 
      stepper1.moveTo(0);
      stepper2.moveTo(0);
      stepper3.moveTo(0);
      stepper4.moveTo(0);
      stepper5.moveTo(0);
      stepper6.moveTo(0);
    }
    shadecmd = UPORDOWN;
    for(int i=0; i<MAX_MOTORS; i++)
    {
    shadeDownPosition[i] = (float) GetEEint(EEadr_shadeDownPosition[i])/4;
    }
  }
}
